//-------------------------------------------------------------------------
//  Copyright (c) 2006, Infrant Technologies, Inc.
//  Copyright (c) 2007, NETGEAR Inc.
//  All rights reserved.
//-------------------------------------------------------------------------

localizedString = new Array();

/* Get and write localized string */
function LS(key) { var ls = localizedString[key]; return ls ? ls : key; }
function WLS(key) { document.write(LS(key)); }

localizedString['CVUFS'] = "Create volume using fixed RAID 0, 1, or 5 level, based on the number of currently installed disks.";
localizedString['UXRAID'] = "Utilize X-RAID technology, which simplifies future volume expansion.";
localizedString['Web Setup'] = "Setup";

var KnownStatus = {
  'ok': { 'short': "Normal",
	'criticality': 'none',
	'desc': "Normal operating mode" },
  'resync':  { 'short': "Awaiting resync",
	'criticality': 'temporary',
	'desc': "Waiting to resync to the RAID volume" },
  'warn': { 'short': "Warning",
	'criticality': 'vulnerable',
	'desc': "Device is in a state where it needs attention" },
  'life_support': { 'short': "Life support mode",
	'criticality': 'critical',
	'desc': "Multiple disk failures detected" },
  'awaiting_recovery': { 'short': "Awaiting recovery",
	'criticality': 'critical',
	'desc': "Disc awaiting recovery" },
  'spare_inactive': { 'short': "Inactive spare",
	'criticality': 'none',
	'desc': "Disk is a spare disk on standby" },
  'not_present': { 'short': "Not Present",
	'criticality': 'none',
	'desc': "No device attached" },
  'fail': { 'short': "Dead",
	'criticality': 'fatal',
	'desc': "Device has failed" },
  'dead': { 'short': "Dead",
	'criticality': 'fatal',
	'desc': "Device has failed" }
};

var CriticalityText = {
	'temporary': ' (this may take a few hours)',
	'vulnerable': ' (take measures, you are at risk of losing data)',
	'critical': ' (data is extremely vulnerable, react immediately!)',
	'fatal': '. Data is most certainly lost.',
	'none': ''
};

var CriticalityMap = {
	'': { '': 'Device is operating incorrectly or failed' },
	'fan': {
		'': 'Fan malfunction: turn off ReadyNAS ASAP, otherwise device may overheat'
	},
	'temp': {
		'': 'Thermometer malfunction: turn off ReadyNAS ASAP, otherwise device may overheat'
	},
	'ups': {
		'': 'Main power supply has failed. UPS is operating on batteries'
	},
	'volume': {
		'': 'Volume malfunction: turn off ReadyNAS ASAP',
		'resync': 'KS',
		'warn': 'KS',
		'life_support': 'KS',
		'awaiting_recovery': 'KS',
		'spare_inactive': 'KS',
		'not_present': 'KS',
		'dead': 'KS'
	},
	'disk': {
		'': 'Disk malfunction: turn off ReadyNAS ASAP',
		'resync': 'KS',
		'warn': 'KS',
		'life_support': 'KS',
		'awaiting_recovery': 'KS',
		'spare_inactive': 'KS',
		'not_present': 'KS',
		'dead': 'KS'
	}
};
