//-------------------------------------------------------------------------
//  Copyright 2006, Infrant Technologies, Inc.
//  Copyright 2007-2009 NETGEAR Inc.
//  All rights reserved.
//-------------------------------------------------------------------------
var debug = 0;
var tempOneTime = 1;
var cstopTimeout = null;
var front = null;	// front side of the widget
var back = null;	// reverse side of the widget
var setup = null;	// reverse side of the widget for raid setup
var gInfoButton = null;
var displayC = !!widget.preferenceForKey(String("Metric")); // C or F
var nominalWidth = 350;
var nominalHeight = 211 + (debug ? 100 : 0);
var currentHeight = nominalHeight;
var raidStore = new RaidStorage();
var FL_RAIDLOCATE  = 4;	/* Blink device's LEDs */
var FL_RAIDSETUP   = 8;	/* Create volume */
var FL_RAIDSUSPEND = 9;	/* Stop countdown timer */

var defaultReadyNASModel = "ReadyNAS NV";
var KnownModel2InfoButtonOffsets = {
	'ReadyNAS NV':    { left: 28, top: 97 },
	'ReadyNAS NV+':   { left: 28, top: 97 },
	'ReadyNAS X6':    { left: 28, top: 37 },
    'ReadyNAS X6-tl': { left: 28, top: 37 },
	'ReadyNAS 600':   { left: 28, top: 37 },
	'ReadyNAS 1000S': { left: 28, top: 63 },
	'ReadyNAS 1100':  { left: 28, top: 63 },
    'ReadyNAS Duo':   { left: 28, top: 90 },
    'ReadyNAS Pro':   { left: 28, top: 97},
    'ReadyNAS NVX':   { left: 28, top: 97 },
    'ReadyNAS 2100': { left: 28, top: 63 },
    'ReadyNAS 3200': { left: 28, top: 63 },

};

var catchTimer = new DynamicTimer(catchPackets, 200,  debug ? 500 : 3000, findDeadDevices);
var queryTimer = new DynamicTimer(queryNetwork, debug ? 500 : 3000, 30000);

function callFewTimes(func) { func(); setTimeout(func, 200); }
String.prototype.trim = function() { return this.replace(/^\s+|\s+$/, ''); }
String.prototype.toInt = function() { return parseInt(this); }
String.prototype.escape = function() {
	var str = this;
	str = str.replace(/&/g, '&amp;');
	str = str.replace(/</g, '&lt;');
	str = str.replace(/>/g, '&gt;');
	str = str.replace(/"/g, '&quot;');
	return str;
}

var ButtonActions = {
  'monitorButton':	{ 'function': showFront },
  'cancelVolumeButton':	{ 'function': showFront },
  'webSetupButton':	{ 'function': showWebSetup, 'disable': 'true' },
  'afpAccessButton':	{ 'function': afpAccess, 'disable': 'true' },
  'createVolumeButton':	{ 'function': createVolumeClicked }
};
var Buttons = new Object();

function bodyLoaded() {
	window.resizeTo(nominalWidth, nominalHeight);
	window.widget.setCloseBoxOffset(14, 3);
	window.widget.onshow = onShow;
	window.widget.onhide = onHide;
	front = document.getElementById("front");
	back = document.getElementById("back");
	setup =  document.getElementById("setup");
	front["updateRaidDisplay"] = updateRaidDisplay;

	for(var bTag in ButtonActions) {
		var ba = document.getElementsByTagName(bTag);
		for(var i = 0; i < ba.length; i++) {
			var buttonCaption = ba[i].getAttribute("caption");
			Buttons[bTag] = new AppleGlassButton(ba[i],
				buttonCaption, ButtonActions[bTag]['function']);
			if(ButtonActions[bTag]['disable'])
				Buttons[bTag].setEnabled(false);
		}
	}

	RaidOSDiscovery.grokNetwork();
	RaidOSDiscovery.installListener();

	onShow();
}

function showPrefs() {
	if(window.widget)
		widget.prepareForTransition("ToBack");
	front.style.display="none"; 
	back.style.display="block"; 
	var maxHeight = currentHeight < nominalHeight
		? nominalHeight : currentHeight;
	window.resizeTo(nominalWidth, maxHeight);
	raidStore.selectedSomething = false;	/* Nothing yet selected */
	if(window.widget) 
		setTimeout('widget.performTransition();', 0);  
}

function showWebSetup() {
	var ip = Buttons['webSetupButton'].raidIP;
	if(ip) widget.openURL("https://" + ip + "/admin/");
}

function afpAccess() {
	var ip = Buttons['afpAccessButton'].raidIP;
	if(ip) widget.openURL("afp://" + ip + "/");
}

function showFront() {
	if(window.widget)
		widget.prepareForTransition("ToFront");
	window.resizeTo(nominalWidth, currentHeight);
	setup.forRaid = null;
	setup.style.display="none"; 
	back.style.display="none"; 
	front.style.display="block"; 
	if(window.widget) 
		setTimeout('widget.performTransition();', 0);  

	/* Blink the LEDs on the selected device */
	if(raidStore.selectedSomething
	&& raidStore.selectedRaidID) {
		var raid = raidStore.raidList[raidStore.selectedRaidID];
		if(raid)
			RaidOSDiscovery.instructDevice(raid.ip, FL_RAIDLOCATE);
	}
}

function createVolumeClicked() {
	var raid = setup.forRaid;
	var st = document.getElementById("status-" + raid.htmlID);
	if(st) {
		st.innerHTML = "Device is setting up...";
		if(raid.rsData) raid.rsData.settingUp = true;
	}
	var msg = '';
	var snapshot = document.getElementById("snapshotSetting");
	var xraidsetting  = document.getElementById("xraidSetting");
	var sgb = snapshot.options[snapshot.selectedIndex].value;
	var msg = "XRAID=" + (xraidsetting.checked ? 1 : 0)
		+ ";SNAPSHOT=" + sgb;
	callFewTimes(function() { RaidOSDiscovery.tellDevice(raid.ip,
		FL_RAIDSETUP, msg); });
	showFront();
}

function onHide() {
	queryTimer.Stop();
	scheduleCoolerStop();
}

// Stop coolers after a few seconds of hidden state (saves CPU)
function scheduleCoolerStop() {
	if(cstopTimeout)
		cstopTimeout = clearTimeout(cstopTimeout);
	cstopTimeout = setTimeout(stopDynamics, 2000);
}

// Stop coolers movement and other dynamic things (saves CPU)
function stopDynamics() {
	var coolers = front.getElementsByTagName("cooler");
	for(var i = 0; i < coolers.length; i++)
		coolers[i].style.display="none";
}

// Display coolers and other dynamic things' movement
function restoreDynamics() {
	if(cstopTimeout) {
		cstopTimeout = clearTimeout(cstopTimeout);
		cstopTimeout = null;
	}
	var coolers = front.getElementsByTagName("cooler");
	for(var i = 0; i < coolers.length; i++)
		coolers[i].style.display="block";
}

function onShow() {
	restoreDynamics();

	RaidOSDiscovery.grokNetwork();

	/* Setup periodic UDP queue checkup */
	queryTimer.Restart();

	tempOneTime = 1;
}

function queryNetwork() {
	RaidOSDiscovery.queryNetwork();
	catchTimer.Restart();
}

function DynamicTimer(callback, fromInterval, toInterval, optStopCallback) {
	if(toInterval <= fromInterval) toInterval = fromInterval;
	this.currentInterval = fromInterval;
	this.fromInterval = fromInterval;
	this.toInterval = toInterval;
	this.callback = callback;
	this.stopCallback = optStopCallback;
	this.timer = null;	/* For one-shots */
	this.intvl = null;	/* For series of shots */
	this.iteration = 0;	/* Number of timer iterations performed */
	this.shots = 0;		/* Number of shots in current iteration */
	var self = this;
	this.onTimer = function() {
		if(self.intvl == null) {
			if(self.timer) clearTimeout(self.timer);self.timer=null;
			self.currentInterval = Math.ceil(
					self.currentInterval * 1.5);
			if(self.currentInterval >= self.toInterval) {
				if(self.stopCallback) {
					self.Stop();
					return;
				} else {
					self.currentInterval = self.toInterval;
					self.intvl = setInterval(self.onTimer,
						self.currentInterval);
				}
			} else {
				self.timer = setTimeout(self.onTimer,
					self.currentInterval);
			}
		}
		self.shots++;
		self.callback();
	}
}
DynamicTimer.prototype.Stop = function() {
	if(this.timer) { clearTimeout(this.timer); this.timer = null; }
	if(this.intvl) { clearInterval(this.intvl); this.intvl = null; }
	if(this.shots) {
		if(this.stopCallback) {
			try { this.stopCallback(); } catch(e) { ; };
		}
		this.iteration++;
		this.shots = 0;
	}
}
DynamicTimer.prototype.Restart = function() {
	this.Stop();
	this.currentInterval = this.fromInterval;
	this.timer = setTimeout(this.onTimer, 100);
	this.intvl = null;
}
DynamicTimer.prototype.Running = function() {
	return (this.timer || this.intvl);
}

prevTemp = 77;	// global
tempDirection = 1;
function catchPackets() {
	var debugHit = false;
	var maxFetches = 50;

	/* Try to read a single packet */
   do {
	var pdata = RaidOSDiscovery.retrieveSingleResult();
	if(pdata == "-") pdata = null;
	if(pdata == "?") { if(maxFetches-- > 0) continue; else break; }
	if(!pdata) {
		if(debug < 10) break;
		if(debug >= 20 && tempOneTime-- <= 0) break;
		debugHit = true;
		prevTemp += 5 * tempDirection
			* Math.floor(2 - Math.random() * 1);
		if(prevTemp > 150 || prevTemp < 10) tempDirection *= -1;
		var macDigit = Math.floor(Math.random() * 3);
		pdata = "00:0D:A2:0"+macDigit+":08:F0"
			+"	raid"+macDigit+".network.com	"
			+ "10.0."+macDigit+"."
			+ Math.floor(1300 + Math.random() * 50)
			+ "	fan!!1!!status=ok::descr="+Math.floor((100+Math.random()*1000))+"RPM"
			+ "\ntemp!!1!!status=ok::descr=26.5C / "
			+ prevTemp
			+ "F::expected=0-60C / 32-140F"
			+ "\nmodel!!1!!descr=ReadyNAS 600"
			+ "\nups!!1!!status=warn::descr=Unknown Belkin UPS\nBattery charge: 100%, 2 min"
			//+ "\nups!!1!!status=warn::descr=American Power Conversion Back-UPS RS 1000\nBattery charge: 100%, 37 min"
			+ "\nvolume!!1!!status=ok::descr=Volume C: RAID Level 1, Redundant, "+Math.round(Math.random() * 100)+"% of 222 GB used"
			+ "\ndisk!!1!!status=ok::descr=Channel 1: Seagate ST3250824AS 232 GB"
			+ "\ndisk!!2!!status=ok::descr=Channel 2: Seagate ST3250824AS 232 GB"
			+ "\ndisk!!3!!status=ok::descr=Channel 3: Seagate ST3250824AS 232 GB"
			+ "\ndisk!!4!!status=ok::descr=Channel 2: Seagate ST3250824AS 232 GB"
			+ "\ndisk!!5!!status=ok::descr=Channel 5: Seagate ST3250824AS 232 GB"
			+ "\ndisk!!5!!status=not_present::descr="
			+ "\ndisk!!6!!status=not_present::descr="
			+ "\ndisk!!7!!status=not_present::descr="
			+ "\ndisk!!8!!status=not_present::descr="
			+ "\ndisk!!8!!status=not_present::descr="
			+ "\n\tRAIDiator!!version=2.00c1-p9,time=1142112000"
			+ "\n\t66"
			;
	}
	processPacket(pdata);
   } while(!debugHit);

}
function processPacket(pdata) {
	try {
		var raid = new RAIDInfo(pdata);
		raidStore.UpdateRaidStatus(raid);
		front.updateRaidDisplay(raid);
	} catch(e) {
		return;
	}
}

function updateRaidDisplay(raid) {

	var rid = raid.htmlID;

	var newRaid;
	var curRaid;
	var oldRaid = document.getElementById(rid);
	if(oldRaid) {
		if(!oldRaid.raidInfo
		|| raid.unparsedPacketData
				!= oldRaid.raidInfo.unparsedPacketData) {
			newRaid = raid.toDOM();
			front.replaceChild(newRaid, oldRaid);
			curRaid = newRaid;
		} else {
			curRaid = oldRaid;
		}
	} else {
		if(raidStore.selectedRaidID) {
			/* Don't show something that is not requested */
			if(raidStore.selectedRaidID != rid)
				return;
		} else {
			/* Do not replace existing device */
			if(raidStore.currentRaidID
			&& raidStore.currentRaidID != rid)
				return;
		}

		newRaid = curRaid = raid.toDOM();
		oldRaid = document.getElementById(raidStore.currentRaidID);
		if(oldRaid) {
			front.replaceChild(newRaid, oldRaid);
		} else {
			front.appendChild(newRaid);
		}
		raidStore.currentRaidID = rid;
	}

	raid.rsData.div = curRaid;
	hidePlaceHolder();
	setWindowToRaidHeight(raid);
}

function setWindowToRaidHeight(raid) {
	/* Adjust display size */
	var newHeight = nominalHeight +
		70 * (raid.volumes.length ? (raid.volumes.length - 1) : 0);
	if(newHeight != currentHeight) {
		currentHeight = newHeight;
		window.resizeTo(nominalWidth, newHeight);
	}
}

var placeHolderHidden = false;
function hidePlaceHolder() {
	if(placeHolderHidden) return;
	placeHolderHidden = true;

	var pholder = document.getElementById("placeholder");
	pholder.style.display = "none";

	if(gInfoButton == null) {
		var ib = front.getElementsByTagName("infoButton")[0];
		gInfoButton = new AppleInfoButton(ib, front,
			"white", "white", showPrefs);
		gInfoButton.parent = ib;
	} else {
		gInfoButton.parent.style.visibility = "visible";
	}
}
function showPlaceHolder() {
	if(!placeHolderHidden) return;
	placeHolderHidden = false;

	var pholder = document.getElementById("placeholder");
	pholder.style.display = "block";
	gInfoButton.parent.style.visibility = "hidden";
}

function RaidStorage() {
	var rs = this;
	this.raidList = new Object();
	this.raidID2IP = new Object();
	this.selectedRaidID = null;
	this.noTimeoutForID = null;
	this.currentRaidID = null;
	this.selectRaid = function(optRaid) {
		rs.selectedRaidID = optRaid ? optRaid.htmlID : null;
		rs.noTimeoutForID = null;
		var a = ['webSetupButton', 'afpAccessButton'];
		for(var i = 0; i < a.length; i++) {
			var b = Buttons[a[i]];
			b.setEnabled(optRaid ? true : false);
			b.raidIP = optRaid ? optRaid.ip : null;
		}
	}
}
RaidStorage.prototype['UpdateRaidStatus'] = function(raid) {
	var id = raid.htmlID;
	var raidText = raid.name + " [" + raid.ip + "]";
	if(!this.display)
		this.display = document.getElementById("display");
	var sel = this.display;

	var oldRaid = this.raidList[id];
	if(oldRaid) {
		raid.rsData = oldRaid.rsData;
		oldRaid.rsData = null;
		if(sel.options[raid.rsData.sIndex].text != raidText);
			sel.options[raid.rsData.sIndex].text = raidText;
	} else {
		var rsData = new Object();
		rsData.id = id;
		rsData.sIndex = sel.length;
		sel.options[rsData.sIndex] = new Option(raidText, id);
		raid.rsData = rsData;
	}
	this.raidList[id] = raid;
	raid.rsData.lastSeenIteration = catchTimer.iteration;
}
function findDeadDevices() { raidStore.findDeadDevices(); }
RaidStorage.prototype['findDeadDevices'] = function() {
	var maxMisses = debug ? 0 : 2;
	var sel = this.display;
	if(!sel) return;

	for(var i = 0; i < sel.length; i++) {
		var rsData;
		try { rsData = this.raidList[sel.options[i].value].rsData; }
		catch(e) { continue; }
		var idiff = catchTimer.iteration - rsData.lastSeenIteration;
		if(idiff > 1 + maxMisses) {
			this.raidDisappeared(rsData);
			i--;
		}
	}
}
RaidStorage.prototype['raidDisappeared'] = function(rsData) {
	if(!this.raidList[rsData.id]
	|| this.raidList[rsData.id].rsData != rsData)
		return;

	var raid = this.raidList[rsData.id];
	var sel = this.display;

	for(var i = rsData.sIndex + 1; i < sel.length; i++) {
		var nextRaid = this.raidList[sel.options[i].value];
		nextRaid.rsData.sIndex--;
	}
	sel.options[rsData.sIndex] = null;
	this.raidList[rsData.id] = null;

	/* Do something with the raid already displayed */
	if(this.currentRaidID == rsData.id) {
		this.markRaidTimeout(rsData);
		if(this.noTimeoutForID != rsData.id)
			unDisplayRaid(raid);
	}
}
RaidStorage.prototype['markRaidTimeout'] = function(rsData) {
	var rid = rsData.id;
	var divRaid = rsData.div;
	if(divRaid) { divRaid.raidInfo = null; }

	var stWrap = document.getElementById("wrap-" + rid);
	if(!stWrap) return;

	var tmDiv;
	stWrap.innerHTML = "";
	tmDiv = document.createElement("div");
	tmDiv.appendChild(document.createTextNode(LS("Unreachable")));
	tmDiv.style.fontSize = "18px";
	tmDiv.style.color = "#d43412";
	tmDiv.style.background = "none";
	tmDiv.style.border = "none";
	tmDiv.style.textShadow = "#202840 0px 4px 5px";
	stWrap.textAlign = "center";
	stWrap.appendChild(tmDiv);

	tmDiv = document.createElement("div");
	tmDiv.appendChild(document.createTextNode(LS("(showing last known state)")));
	tmDiv.style.color = "#ffffff";
	tmDiv.style.fontFamily = "Verdana, sans-serif";
	tmDiv.style.fontSize = "10px";
	tmDiv.style.fontWeight = "normal";
	stWrap.appendChild(tmDiv);
}

function unDisplayRaid(raid) {
	/*
	 * If the user has not selected a RAID, and if there are multiple
	 * of them running, just switch to a different RAID.
	 */
	if(!raidStore.selectedRaidID
	&& raidStore.display.length > 2
	&& 0 /* Do not auto-confuse the user */) {
		findOtherDevice();
		return;
	}

	var div = document.getElementById("frontOverlay");
	if(div) front.removeChild(div);
	div = document.createElement("frontOverlay");
	div.forRaid = raid;
	div.id = "frontOverlay";
	div.style.height = currentHeight - 22 - 30;
	var tmp = document.createElement("DIV");
	tmp.style.fontSize = "12px";
	tmp.appendChild(document.createTextNode(
		raid.name + LS(" is not responding. ")));
	tmp.appendChild(document.createTextNode(
		LS("This might be a temporary network problem or a serious issue with the ReadyNAS hardware. ")));
	div.appendChild(tmp);
	var qText = document.createElement("DIV");
	qText.appendChild(document.createTextNode(LS("Look for other devices?")));
	qText.style.color = "#f08040";
	qText.style.marginTop = "5px";
	div.appendChild(qText);

	var qSearch = document.createElement("DIV");
	new AppleGlassButton(qSearch, LS("Yes, find another device"), findOtherDevice);
	qSearch.style.marginTop = "5px";
	qSearch.style.marginBottom = "5px";
	div.appendChild(qSearch);

	var qWait = document.createElement("DIV");
	new AppleGlassButton(qWait,
		LS("No, just wait until it answers"),
			waitUntilAvailable);
	div.appendChild(qWait);
	front.appendChild(div);
}

function findOtherDevice() {
	var div = document.getElementById("frontOverlay");
	if(div) front.removeChild(div);
	var haveOtherDevicesAlive = (raidStore.display.length > 1);

	var divRaid = document.getElementById(raidStore.currentRaidID);
	if(divRaid) {
		if(haveOtherDevicesAlive)
			divRaid.raidInfo = null;
		else
			front.removeChild(divRaid);
	}

	raidStore.selectRaid(null);

	if(haveOtherDevicesAlive) {
		var newRaid = raidStore.raidList
				[raidStore.display.options[1].value];
		raidStore.display.selectedIndex = 1;
		raidStore.selectRaid(newRaid);
		front.updateRaidDisplay(newRaid);
		raidStore.selectRaid(null);
	} else {
		showPlaceHolder();
		raidStore.display.selectedIndex = 0;
	}
}
function waitUntilAvailable() {
	var div = document.getElementById("frontOverlay");
	if(div) front.removeChild(div);

	raidStore.selectRaid(div.forRaid);
	raidStore.noTimeoutForID = raidStore.selectedRaidID;	// Do not timeout this raid
}

function raidDblClicked(sel) {
	raidStore.selectedSomething = true;
	raidClicked(sel);
	showFront();
}

function raidClicked(sel) {
	var sIndex = sel.selectedIndex;
	if(raidStore.selectedRaidID == sel.options[sIndex].value)
		return;	/* Already selected */

	var sValue = sel.options[sIndex].value;
	var raid = raidStore.raidList[sValue];
	if(raid) {
		raidStore.selectRaid(raid);
		front.updateRaidDisplay(raid);
	} else {
		/* Probably "show all" was selected */
		raidStore.selectRaid(null);
	}
	raidStore.selectedSomething = true;
}

function changeMeasurement(temp) {
	displayC = !displayC;	// Toggle measurement units
	var divs = front.getElementsByTagName("div");
	for(var i = 0; i < divs.length; i++) {
		var div = divs[i];
		var c = div.getAttribute("c");
		var f = div.getAttribute("f");
		if(!c || !f) continue;
		var tn = document.createTextNode(displayC ? c : f);
		div.replaceChild(tn, div.firstChild);
	}
	widget.setPreferenceForKey(displayC ? String("Yes") : null,
		String("Metric"));
}

function magnifyText(div) {
	if(!div.oldStyle) {
		div.oldStyle = new Object();
		div.oldStyle.fontSize = div.style.fontSize;
		div.style.position = "absolute";
		div.style.left = "-48px";
		div.style.width = "294px";
		div.style.height = "125px";
		div.style.zIndex = 100;
		div.style.fontSize = "11px";
		div.style.opacity = "0.9";
	} else {
		div.style.position = "relative";
		div.style.left = undefined;
		div.style.width = undefined;
		div.style.height = undefined;
		div.style.fontSize = div.oldStyle.fontSize;
		div.oldStyle = null;
	}
}

function displayDiskStatus(disk) {
	var status = disk.getAttribute("status");
	var descr = disk.getAttribute("descr");
	var text = KnownStatus[status]["short"];

	var color;
	switch(KnownStatus[status]["criticality"]) {
	case "vulnerable": color = "#FFF090"; break;
	case "critical": color = "#F85830"; break;
	case "fatal": color = "#000000"; break;
	default: color = "#50FF77"; break;
	}

	text = descr + "<br>"
			+ (descr ? (LS("Status:")
				+ " <span style=\"color: "+color+"\">"
				+ text + "</span>") : LS("Empty drive slot"));
	displayNote(text);
}

function displayUPSStatus(disk) {
	var status = disk.getAttribute("status");
	var descr = disk.getAttribute("descr");
	var text = KnownStatus[status]["short"];

	var color;
	switch(KnownStatus[status]["criticality"]) {
	case "vulnerable": color = "#FFF090"; break;
	case "critical": color = "#F85830"; break;
	case "fatal": color = "#000000"; break;
	default: color = "#50FF77"; break;
	}

	text = descr + "<br>"
			+ LS("Status:")
			+ " <span style=\"color: "+color+"\">"
			+ text + "</span>";
	displayNote(text);
}

function displayNote(noteText) {
	if(!raidStore.currentRaidID) return;
	var noteID = "note-" + raidStore.currentRaidID;
	var statusID = "status-" + raidStore.currentRaidID;
	var note = document.getElementById(noteID);
	var status = document.getElementById(statusID);
	if(!note || !status) return;
	note.innerHTML = noteText;
	note.style.display = "block";
	status.style.display = "none";
	note.discard = function() {
		note.style.display = "none";
		status.style.display = "block";
	}
	if(note.tmpTimer) clearTimeout(note.tmpTimer);
	note.tmpTimer = setTimeout(note.discard, 2000);
}

function RAIDInfo(pdata) {
	pdata = pdata.escape();	// Replace unsafe chars with entity references

	var outerArr = pdata.split("\t");
	if(outerArr.length != 5 && outerArr.length != 6)
		throw "Invalid data format";

	var arr = outerArr[3].replace(/\n([^ :%]+!)/g, "\t$1").split("\t");
	if(arr.length < 2)
		throw "Invalid data in property lists";

	this.unparsedPacketData = pdata;
	this.failString = '';
	this.mac = outerArr[0];
	this.name = outerArr[1];
	this.ip = outerArr[2];
	this.htmlID = "id-" + this.mac;
	this.versionUnparsed = outerArr[4];
	this.software = outerArr[4].replace(/^([a-z]+).*/i, "$1");
	this.version = outerArr[4].replace(/.*(version=(.*),).*/, "$2");
	if(!this.version.match(/[0-9]/)) this.version = null;
	this.bootFlag = outerArr[5];

	this.fan = null;
	this.temp = null;
	this.ups = null;
	this.model = null;
	this.disks = new Array();
	this.volumes = new Array();

	this.parseArray = arr;

	for(var i = 0; i < arr.length; i++) {
	  try {
		var raidProp = this.parseProperty(arr[i]);
		if(!raidProp) continue;
		switch(raidProp.type) {
		case "fan": this.fan = new RaidFan(raidProp); break;
		case "temp": this.temp = new RaidTemperature(raidProp); break;
		case "disk": this.disks.push(new RaidDisk(raidProp)); break;
		case "volume": this.volumes.push(new RaidVolume(raidProp)); break;
		case "ups": this.ups = new RaidUPS(raidProp); break;
		case "model": this.model = raidProp.descr; break;
		}
		if(raidProp.failString) {
			this.failString = raidProp.failString
				+ "<BR>" + this.failString;
		}
	  } catch(e) {
		if(debug)
		front.innerHTML += "ParseProperty [" + arr[i] + "]: ["+e+"]";
		continue;
	  }
	}

	if(this.model)
	this.model = this.model.replace(/^([^\s]+)[\s]+([^-\s]+)(.*[\s]?)*$/m,
			"$1 $2");
	if(!this.model || !KnownModel2InfoButtonOffsets[this.model])
		this.model = defaultReadyNASModel;
}
RAIDInfo.prototype['diskSlots'] = function() {
	if(this.disks.length <= 4) return 4;
	return this.disks.length;
}

RAIDInfo.prototype['parseProperty'] = function(line) {
	var parts = line.split("!!");
	if(parts.length != 3) return null;

	var prop = new Object();

	prop.string = line;
	prop.type = parts[0];
	prop.num = parts[1];
	prop.key = new Array();
	prop.status = null;
	prop.descr = null;
	prop.failString = '';

	var kVals = parts[2].split("::");

	for(var i = 0; i < kVals.length; i++) {
		var kv = kVals[i].split("=");
		if(kv.length != 2) continue;
		switch(kv[0]) {
		case "status": prop.status = RaidPropertyStatus(kv[1]); break;
		case "descr": prop.descr = kv[1]; break;
		default: prop.key[kv[0]] = kv[1]; break;
		}
	}

	if(!prop.status && prop.type == "model")
		prop.status = RaidPropertyStatus("ok");
	if(!prop.status)
		throw "No status in property: " + line;
	if(prop.descr == null)
		throw "No descr in property: " + line;

	/*
	 * Prepare human readable explanation to a critical problem.
	 */
	var ctext = CriticalityText[prop.status.criticality];
	if(ctext) {
		var cmap = CriticalityMap[prop.type];
		if(!cmap) cmap = CriticalityMap[''];
		var expln = cmap[prop.status.string];
		if(!expln) expln = cmap[''];
		if(expln) {
			if(expln == "KS")
				expln = prop.status.description;
			prop.failString = "<device>"
				+ prop.type + prop.num + "</device>: "
				+ expln + ctext;
		}
	}

	return prop;
}

function StatusNoteHandler(div, func) {
	this.eventDiv = div;
	var _self = this;
	this._mouseOver = function(event) {
		if(_self.insideMO)
			return;
		_self.insideMO = true;
		func(_self.eventDiv);
	}
	this._mouseOut = function(event) {
		_self.insideMO = false;
	}
	this.eventDiv.addEventListener("mouseover", this._mouseOver, false);
	this.eventDiv.addEventListener("mouseout", this._mouseOut, false);
	return this;
}

function setStatusUpdater(raid, tag, func) {
	// Setup mouseover/mouseout events
	var el = raid.getElementsByTagName(tag);
	for(var i = 0; i < el.length; i++) {
		var div = el[i];
		div.reactor = new StatusNoteHandler(div, func);
	}
}

RAIDInfo.prototype['toDOM'] = function() {
	var raid = this;
	var div = document.createElement("DIV");
	div.innerHTML = raid.toHTML();
	var divRaid = div.firstChild;
	divRaid.raidInfo = raid;
	div = null;

	var ibOffsets = KnownModel2InfoButtonOffsets[raid.model];
	var infoButton = front.getElementsByTagName("infoButton")[0];
	infoButton.style.top = ibOffsets.top;
	infoButton.style.left = ibOffsets.left;
	var imgBack = document.getElementById("imageModelBack");
	imgBack.setAttribute("model", raid.model);

	setStatusUpdater(divRaid, "diskStatus", displayDiskStatus);
	setStatusUpdater(divRaid, "ups", displayUPSStatus);
	var setups = divRaid.getElementsByTagName("setup");
	if(setups && setups.length == 1) {
		raid.raidSetupClicked = function() {
			showPrefs();
			back.style.display="none"; 
			setup.style.display="block"; 
			setup.forRaid = raid;
			/* Send a suspend packet a couple of times */
			callFewTimes(function() {
				RaidOSDiscovery.instructDevice(raid.ip,
					FL_RAIDSUSPEND); });
		}
		divRaid.setupButton = new AppleGlassButton(setups[0],
			LS("Setup"), raid.raidSetupClicked);
	}

	return divRaid;
}
RAIDInfo.prototype['toHTML'] = function() {
	var html = "";

	html += "<raid id=\"" + this.htmlID + "\" class=newRaid>";
	if(this.fan) html += this.fan.toHTML();
	html += "<raidImage onClick=\"showPrefs();\"";
	html += " model=\"" + this.model + "\">";
	html += "<div class=raidGlow status=\""
		+ (this.failString?"not ok":"ok") +"\"></div>";
	html += "</raidImage>";
	html += "<div class=raidId>";
	html += "<div class=raidName>" + this.name + "</div>";
	html += "<div class=raidIP>"+this.ip+"</div>";
	html += "</div>";	/* raidId */
	html += "<div class=newRaidBody>";
	html += "<div class=raidInfo>";
	if(this.version)
		html += "<div class=raidVer>"+this.software + ": " + this.version+"</div>";
	html += "<div class=raidMAC>"+this.mac+"</div>";
	html += "<statusWrap id=\"wrap-"+this.htmlID+"\">";
	html += "<statusNote id=\"note-"+this.htmlID+"\"></statusNote>";
	if(!this.bootFlag) {
		html += "<status id=\"status-"+this.htmlID+"\" setup>";
		if(this.rsData && this.rsData.settingUp) {
			html += LS("Device is setting up...");
		} else {
			html += LS("Device requires setup:") + "<setup/>";
		}
		html += "</status>";
	} else if(this.failString) {
		html += "<status id=\"status-"+this.htmlID+"\" fail=\"true\""
			+ " onClick=\"magnifyText(this);\""
			+ "><span style=\"font-size: 14px; "
				+ "font-weight: bold; color: #fff0f0\">"
				+ LS("Attention!") + "</span>"
			+ "<br>" + this.failString + "</status>";
	} else {
		html += "<status id=\"status-"+this.htmlID+"\">OK</status>";
	}
	html += "</statusWrap>";
	html += "</div>";	// raidInfo

	if(this.temp) html += this.temp.toHTML();
	if(this.ups) html += this.ups.toHTML();
	html += "<div style=\"height: 80px;\"></div>"

	html += "<div class=disks>";
	html += "<div class=diskImage></div>";
	html += "<div class=disksTitle>" + LS("Drives") + "</div>";
	var slots = this.diskSlots();
	html += "<div class=diskSet slots=\"+slots+\">";
	for(var i = 0; i < this.disks.length; i++) {
		if(i == slots) break;
		this.disks[i].noteID = "note-" + this.htmlID;
		this.disks[i].statusID = "status-" + this.htmlID;
		html += this.disks[i].toHTML(slots);
	}
	html += "<div class=afterLastDisk></div>";
	html += "</div>";
	html += "</div>";

	for(var i = 0; i < this.volumes.length; i++)
		html += this.volumes[i].toHTML();

	html += "<div style=\"clear: both;\"></div>";
	html += "</div>";	// newRaidBody
	html += "<div class=newRaidBottom></div>";
	html += "</raid>";
	return html;
}

RaidVolume.prototype['toHTML'] = function() {
	var html = "";
	html += "<div class=volume>"
	html += "<div class=volumeUsed used=\""
			+ (this.used > 95 ? "7"
				: Math.round(this.used * 6 / 100))
		+ "\">";
	html += "<div class=volumeGlow"
	html += " status=\""+this.property.status.string+"\"></div>";
	html += "<div class=volumeUsedText>" + this.used + "</div></div>";
	html += "<div class=volumeName>" + this.name + "</div>";
	for(var i = 0; i < this.infoSet.length; i++)
		html += "<div class=volumeInfoString>"
			+ this.infoSet[i] + "</div>";
	html += "</div>";	/* volume */
	return html;
}

RaidDisk.prototype['toHTML'] = function(slots) {
	var html = "";
	html += "<div class=disk "
		+ " slots=\"" + slots +  "\""
		+ " descr=\"" + this.descr + "\">";
	html += "<diskStatus"
		+ " onClick=\"displayDiskStatus(this);\""
		+ " descr=\""+this.descr+"\""
		+ " status=\"" + this.property.status.string + "\">";
	html += "</diskStatus>";
	html += "</div>";	/* disk */
	return html;
}

RaidTemperature.prototype['toHTML'] = function() {
	var html = "";
	var tfill = 20;
	var fnMin = 30;	// comfortable minimum for the device
	var fnMax = 60;	// comfortable maximum for the device
	var efMin = 15;	// absolute minimum thermometer can display
	var efMax = 75;	// absolute maximum thermometer can display

	var range = this.maxF - this.minF;
	if(range <= 50) range = 50;		// just in case
	if(this.minF < 32) this.minF = 32;	// just in case

	tfill = fnMin + (this.tempF - this.minF) * (fnMax-fnMin) / range;
	tfill = Math.floor(tfill);
	if(tfill < efMin) tfill = efMin;
	else if(tfill > efMax) tfill = efMax;

	// Convert thermometer fill into space pixels.
	var topSpace = 77 - tfill;
	if(topSpace < 0) topSpace = 0;
	else if (topSpace > 77) topSpace = 77;

	var glowColor = '';
	if(this.property.status.string == "ok") {
		if(this.tempF > this.maxF) {
			glowColor = "glow=\"red\"";
			this.property.status.string = "warn";
		} else if(this.tempF < this.minF) {
			glowColor = "glow=\"blue\"";
			this.property.status.string = "warn";
		}
	}

	html += "<div class=temp>"
	if(displayC) {
		var tMin = this.minC;
		var tCur = this.tempC;
		var tMax = this.maxC;
	} else {
		var tMin = this.minF;
		var tCur = this.tempF;
		var tMax = this.maxF;
	}

	html += "<div class=tempBg onClick=\"changeMeasurement(this);\">";
	html += "<div class=tempMax c=\""+this.maxC+"&deg;\" f=\""
			+this.maxF+"&deg;\">"+tMax+"&deg;</div>";
	html += "<div class=tempCur " + glowColor
	html += " c=\""+this.tempC+"&deg;C\" f=\""+this.tempF+"&deg;F\""
	html += " status=\""+this.property.status.string+"\">";
	html += tCur + "&deg;"+(displayC?"C":"F") + "</div>";
	html += "<div class=tempMin"
	html += " c=\""+this.minC+"&deg;\" f=\""+this.minF+"&deg;\">"
			+tMin+"&deg;</div>";
	html += "<glow class=tempGlow " + glowColor
	html += " status=\""+this.property.status.string+"\">";
	html += "<div class=tempVPAD style=\"height: "+topSpace+"px;\"></div>"
	html += "<div class=tempFill ";
	html +=   "style=\"height: "+(77-topSpace)+"px;";
	html +=   "background-position: 0px "+(-topSpace)+"px;\"></div>";
	html += "</glow>";	/* tempGlow */
	html += "</div>";	/* tempBg */
	html += "</div>";	/* temp */
	return html;
}

RaidFan.prototype['toHTML'] = function() {
	var html = "";
	var running = true;
	var imgName = "cooler-spin.gif";
	if(this.property.status.string == "warn"){
		running = false;
		imgName = "cooler-hot.png";
	}

	html += "<cooler "+(running?"running":"")+">";
	html += "<img src=images/"+imgName+"></cooler>";
	html += "<div class=fan status=\""+this.property.status.string+"\">";
	html += LS("Fan: ") + this.descr;
	html += "</div>";	/* fan */
	html += "</cooler>";
	return html;
}

RaidUPS.prototype['toHTML'] = function() {
	var html = "";
	html += "<ups class=\"ups\""
		+ " status=\"" + this.property.status.string + "\""
		+ " descr=\"" + this.descr + "\">";
	html += "<div class=\"upsGlow\""
		+ " status=\"" + this.property.status.string + "\"></div>";
	var ups = this.descr;
	ups = ups.replace(/^Unknown /, "");
	ups = ups.replace(/American Power Conversion/, "APC");
	ups = ups.replace(/([^ \n]+).*\n/, "$1\n");
	ups = ups.replace(/\n([^ :]+)?.*:/, " $1:");
	//html += ups;
	var upsCharge = ups.replace(/.* ([0-9]+%).*/, "$1");
	var upsTimeLeft = ups.replace(/.*, ([0-9]+.*)/, "$1");
	if(upsTimeLeft.match(/^[0-9]\s*$/)) upsTimeLeft += LS(" min");
	var charge = upsCharge.toInt();
	if(charge < 0) charge = 0;
	if(charge >= 100)
		charge = 60;
	else
		charge = 7 + Math.ceil(charge / (100 / 42));
	html += "<div class=\"upsFill\""
		+ " style=\"width: " + (charge) + "px\">";
	html += "<div class=\"upsCharge\" front>" + upsCharge + "</div>";
	html += "</div>";
	html += "<div class=\"upsTimeLeft\">" + upsTimeLeft + "</div>";

	html += "<div class=\"upsCharge\">" + upsCharge + "</div>";
	html += "</ups>";	/* UPS */
	return html;
}

function RaidFan(prop) {
	this.property = prop;
	this.descr = prop.descr;
	this.rpms = parseInt(this.descr);
	if(prop.status.string == "warn") {
		prop.failString = "<device>"
				+ prop.type + prop.num + "</device>: "
				+ LS("running too slow to be useful!")
				+ " "
				+ LS("Repair the fan to avoid overheating.");
    }
}

function RaidTemperature(prop) {
	this.property = prop;
	this.descr = prop.descr;

	var dsc = prop.descr.split("/");
	var exp = prop.key["expected"].split("/");

	this.tempC = 0;
	this.tempF = 32;
	this.minC = 0;
	this.maxC = 60;
	this.minF = 32;
	this.maxF = 140;

	try {
	this.tempC = dsc[0].replace(/[CF]/, '').trim().toInt();
	this.tempF = dsc[1].replace(/[CF]/, '').trim().toInt();
	this.minC = exp[0].replace(/-.*/, '').trim().toInt();
	this.maxC = exp[0].replace(/^[0-9]+-/, '').replace(/[CF].*/, '').toInt();
	this.minF = exp[1].replace(/-.*/, '').trim().toInt();
	this.maxF = exp[1].replace(/[ ]*[0-9]+-/, '').replace(/[CF].*/, '').toInt();
	} catch(e) {;}

	/* Enforce limits */
	if(prop.status.string == "ok") {
		if(this.tempF > this.maxF) {
			prop.failString = "<device>"
			+ prop.type + prop.num + "</device>: "
			+ LS("Thermometer reading is too high!")
			+ " "
			+ LS("Repair the fan to avoid overheating.");
		} else if(this.tempF < this.minF) {
			prop.failString = "<device>"
			+ prop.type + prop.num + "</device>: "
			+ LS("Thermometer reading is too low!")
			+ " "
			+ LS("Switch off the device to avoid humidity buildup.");
		}
	}

	return this;
}

function RaidDisk(prop) {
	this.property = prop;
	this.descr = prop.descr;
}

function RaidVolume(prop) {
	this.property = prop;
	this.descr = prop.descr;

	try {
		this.name = prop.descr.replace(/^([^:]+).*/, "$1");
	} catch(e) {
		this.name = LS('Volume 1');
	}

	try {
	   this.raidLevel = prop.descr.replace(/^[^:]+:[ ]*([^,]+).*/, "$1");
	} catch(e) { this.raidLevel = LS('RAID level unknown'); }

	try {
	  this.raidStatus = prop.descr.replace(/^[^:]+[^,]+,[ ]*([^,.;]+).*/, "$1");
	  this.raidStatus = this.raidStatus.replace(/Resync ([0-9]+).*/, "Resyncing: $1%");
	} catch(e) { this.raidStatus = null; }

	try {
        this.used = prop.descr.replace(/.*[\s(]([0-9]+)%.*/, "$1");
	  
	} catch(e) { this.used = 0; }

	try {
	  this.capacity = prop.descr.replace(/.* ([0-9]+ [^ ]+) .*/, "$1");
	} catch(e) { this.capacity = LS("unknown capacity"); }

	this.infoSet = new Array();
	/* Populate */
	this.infoSet.push(this.raidLevel);
	if(this.raidStatus)
		this.infoSet.push(this.raidStatus);
	this.infoSet.push(this.capacity);
	/* Sort */
	if(this.infoSet[0].length < this.infoSet[1].length) {
		var tmp = this.infoSet[0];
		this.infoSet[0] = this.infoSet[1];
		this.infoSet[1] = tmp;
	}

}

function RaidUPS(prop) {
	this.property = prop;
	this.descr = prop.descr;
}

function RaidPropertyStatus(statusString) {
	var ks = KnownStatus[statusString];
	if(!ks) ks = KnownStatus["warn"];

	var status = new Object();
	status.string = statusString;
	status.criticality = ks["criticality"];
	status.shortDescription = ks["short"];
	status.description = ks["desc"];

	return status;
}
